---
myst:
  html_meta:
    keywords: tableau, tableaux, facile, facilement, complexe, joli
---

# Comment construire un tableau avec le package <ctanpkg:tabularray> ?

Le package <ctanpkg:tabularray> permet de composer des tableaux complexes simplement. La
syntaxe permet une séparation fond/forme qui correspond bien à la philosophie de LaTeX 
et rend le code particulièrement lisible.

Une de ses principales forces est également de permettre de régler l’aspect d’un tableau
**sans connaître *a priori* le nombre de colonnes et de cellules**.

Il fournit l’environnement suivant : 

```{noedit}
\begin{tblr}{⟨description du tableau⟩}
	⟨contenu du tableau⟩
\end{tblr}
```

:::{note}
- Avant d’utiliser ce package, il est conseillé de connaître les rudiments de la
[composition classique de tableaux](/3_composition/tableaux/construire_un_tableau.md).
- La documentation de <texdoc:tabularray> propose plusieurs syntaxes possibles, dont
certaines respectant moins la séparation fond/forme, qui ne seront pas présentées ici.
:::

## Colonne de base 
Le type de colonnes (et de lignes) de base est notée `Q`.

Les réglages se font dans la description du tableau,  à l’aide des options `colspec` et
`rowspec`. 

### Largeur et hauteur
Pour ces réglages, on indique la largeur de chaque colonne dans `colspec` et la hauteur de
chaque ligne dans `rowspec`.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	colspec ={| Q[1.5cm]| Q[3cm] | Q[5 cm] |},
	rowspec={| Q[1cm] || Q[3cm] |Q[2cm] |}
}
It’s a yellow submarine
    & yellow submarine
    &  yellow submarine \\
    %
Oubladi
	& oublada
	& oubladi \\
    %
Michelle, ma belle 
    & sont des mots
    & qui vont très bien \\
\end{tblr}

\end{document}
```

### Alignement vertical et horizontal
L’alignement du texte peut être indiqué dans, au choix, `rowspec` ou `colspec`.

Les valeurs possibles pour l’alignement horizontal sont les mêmes que pour les tableaux
classiques : `l` (par défaut), `c` et `r`. 

Pour l’alignement vertical, c’est un peu plus délicat : 
- `m` : comme « *middle* », aligne la ligne du milieu sur la ligne de base (bref, au milieu de la ligne).
- `t` : comme « *top* », aligne le sommet du texte sur la ligne de base. Le texte sera donc
  « en dessous » de la ligne de base.
- `h` : comme « head », aligne le sommet du texte sur le haut de la cellule.
- `b`: comme « *bottom* », aligne le bas du texte de la cellule sur la ligne de base. Le
  texte sera donc « au-dessus ».
- `f` : comme « *foot* », aligne le bas du texte sur le bas de la ligne.

Dans l’exemple ci dessous, on voit bien la différence entre les différentes possibilités.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	colspec={| Q[m,2cm] || Q[t,2cm] |Q[h,2cm] || Q[b,2cm] | Q[f,2cm] |},
	rowspec={| Q[4cm,c] |}	
}
    {oubladi \\ oublada \\ oubladi}
    & {oubladi \\ oublada }
    & {Michelle \\ ma belle}
    & {sont des \\ mots qui}
    & { vont très \\ bien ensemble} \\
\end{tblr}

\end{document}
```

:::{note} 
Les retours à la ligne dans une cellule s’obtiennent en mettant son contenu
entre accolades, puis avec `\\`.
:::

### Un peu de couleur

Pour ajouter de la couleur au tableau, il suffit de charger le package <ctanpkg:xcolor>.

<ctanpkg:tabularray> charge également le package <ctanpkg:ninecolors> pour la gestion des
couleurs. Ce dernier permet d’avoir un grand nombre de couleurs et de nuances prédéfinies.

La couleur d’une ligne ou d’une colonne s’ajoute dans le descriptif du tableau.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{tabularray}
\usepackage{xcolor}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	colspec ={| Q[l, 2cm, cyan7] | Q[c, 1.5cm, cyan4] | Q[r, 1.5cm, blue7] |},
	rowspec={| Q[m] || Q[t, 2cm] |Q[b, 1.5cm] |}
}
O flower of Scotland
	& When will we
	&  see your like again \\
%
That fought and died for
	& Your wee bit hill and glen
	& And stood against him \\
%
Proud Edward's army
	& And sent him homeward
	& Tae think again
\end{tblr}

\end{document}
```

## Colonnes `X` pour largeur automatique
### Une colonne `X` dans le tableau
Les colonnes de type `X` adaptent leur largeur de manière à ce que le tableau occupe
toute la largeur disponible.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{tabularray}
\usepackage{xcolor}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	colspec ={| X[l, cyan7] | Q[c, 2cm, cyan4] | Q[r, 1.5cm, blue7] |},
}
Je ne 
	& veux pas
    & travailler \\
%
Je ne veux
    & pas
    & déjeuner \\
%
Je veux
    & seulement
    & oublier
\end{tblr}

\end{document}
```

### Plusieurs colonnes `X`
On peut mettre plusieurs colonnes `X`, et *régler leurs largeurs relatives*. Dans l’exemple suivant,
la deuxième colonne a une largeur 1,5 fois plus grande que la première, et la troisième
colonne, 3 fois plus grande.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
    colspec={ |X[l,cyan7] | X[1.5, c, cyan4] | X[3, r, blue7] |}
}
O flower of Scotland
	& When will we
	&  see your like again \\
%
That fought and died for
	& Your wee bit hill and glen
	& And stood against him \\
%
Proud Edward's army
	& And sent him homeward
	& Tae think again
\end{tblr}

\end{document}
```


## Autre syntaxe
<ctanpkg:tabularray> fournit aussi une autre possibilité de syntaxe pour la description
du tableau. Elle permet un réglage plus fin de l’aspect des cellules.


### Réglage global
Dans le descriptif du tableau, on utilise les options  `rows`, `columns`, `hlines`, et
`vlines` dont les valeurs s’appliqueront à toutes les colonnnes, lignes, et filets.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	hlines, 
	vlines = {red,2pt},
	columns = {c, cyan9},
	rows = {m, 1.5cm}
}
Je ne 
    & veux pas
    &  travailler \\
    %
    Je ne veux
    & pas
    & déjeuner \\
    %
Je veux
    & seulement
    & oublier
  \end{tblr}

\end{document}
```

### Clefs disponibles
Dans l’exemple précédent, les clefs utilisées pour chaque option sont implicites et on
indique uniquement leur valeurs. La plupart du temps il n’est pas nécessaire de les
indiquer explicitement, et on peut se contenter de donner valeur souhaitée pour chacune.

:::{caution} Certaines clefs comme `halign` ou `valign` peuvent être utilisées
pour le réglage des colonnes ou des lignes, ce qui n'est pas le cas
d’autres. Par exemple, `ht` (*height dimension*) n’est disponible que pour les
lignes et `wd` (*width dimension*) que pour les colonnes.
:::

La version explicite de l’exemple serait : 
```{noedit}
\begin{tblr}{
	hlines, 
	vlines = {bg=red,2pt},
	columns = {halign=c, fg=cyan9},
	rows = {valign=m, ht=1.5cm}
}
```

Les clefs les plus utilisées sont celles du tableau suivant.

| Clef     | Description                           | Valeurs possibles             |
|----------|---------------------------------------|-------------------------------|
| `halign` | alignement horizontal                 | `l`, `c`, `r`, `j` (justifié) |
| `valign` | alignement vertical                   | `m`, `b`, `t`, `h`, `f`       |
| `wd`     | largeur de colonne                    | valeur en cm ou en pt         |
| `ht`     | hauteur de ligne                      | valeur en cm ou en pt         |
| `bg`     | couleur de fond (*background color*)  | nom de la couleur             |
| `fg`     | couleur du texte (*foreground color*) | nom de la couleur             |
| `font`   | réglage de la police                  | `\bfseries`, `\itshape`, ...  |

:::{note} On pourra se reporter au pages 20 et 21 de la documentation
(<texdoc:tabularray>) pour voir l’ensemble des clefs disponibles et les
possibilités qu’elles offrent.
:::


### Réglage d’une ligne/colonne/cellule particulière

On peut régler les cellules, colonnes ou lignes indivivuellement en utilisant des clefs
dont les noms sont les mêmes que précédemment, mais au singulier :

Quelques exemples : 

- `row{2}` : deuxième ligne 
- `row{1,4}` : lignes 1 ET 4
- `column{1-4}` : colonnes 1 À 4
- `hline{1}` : premier filet horizontal
- `vline{1,3}` : premier et troisième filets verticaux
- `cell{⟨colonnnes⟩}{⟨lignes⟩}` : choix d’une ou plusieurs cellules

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	hlines, vlines,
	columns = {c},
	hline{2} = {dashed, red, 2pt},
	rows = {m, 1.5cm},
	column{1} = {font = \bfseries},
	row{1,3} = {fg=red},
	cell{1}{2} = {bg=cyan8},
	cell{1,3}{3} = {font = \itshape}
}
Je ne 
    & veux pas
    &  travailler \\
% 
Je ne veux
    & pas
    & déjeuner \\
% 
Je veux
    & seulement
    & oublier
\end{tblr}

\end{document}
```

## Fusion de cellules
<ctanpkg:tabularray> permet également de fusionner des cellules. Pour cela on ajoute à
l’option `cell`, les clefs `r` pour le nombre de lignes et `c` pour le nombre de colonnes
que prendra la cellule.

:::{note}
On peut voir dans l’exemple ci-dessous que, si du texte est présent dans les cellules qui
sont fusionnées, il est ignoré.
:::

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	hlines, vlines,
	columns = {c, cyan9},
      rows = {m, 1.5cm},
      cell{2}{2} = {c=2}{fg=red, bg=yellow},
      cell{1}{1} = {r=3}{font=\bfseries}
}
Il portait des culottes
    & des bottes 
    & de moto \\
% 
IGNORÉE
    & Un blouson de 
    & IGNORÉE \\
% 
IGNORÉE
    & cuir noire avec
    & un aigle sur le dos
  \end{tblr}
  
\end{document}
```

## Gestion des filets
Pour gérér les filets verticaux et horizontaux, la syntaxe est très proche de
ce qui a été vu pour les lignes et les colonnes. 

Les options `hlines` et `vlines` permettent d’avoir des filets horizontaux et verticaux
partout. 

Les options `hline` et `vline` permettent de sélectionner un filet particulier.

Dans tous ces cas, les clefs possibles sont les suivantes : 

| Clef   | Description                    | Valeurs possibles           |
|--------|--------------------------------|-----------------------------|
| `fg`   | couleur                        | `cyan4`, `olive8`, ...      |
| `text` | remplace la ligne par du texte | une lettre par exemple      |
| `wd`   | épaisseur                      | valeur en pt, ou en cm      |
| `dash` | style de ligne                 | `solid`, `dashed`, `dotted` |

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}

\begin{tblr}{
	hlines, 
	vlines,
	hline{1}={red, 2pt, dashed},
	vline{2}={cyan2, 4pt, dotted}
}
    {oubladi \\ oublada \\ oubladi}
    & {oubladi \\ oublada }
    & {Michelle \\ ma belle}
    & {sont des \\ mots qui}
    & { vont très \\ bien ensemble} \\
\end{tblr}

\end{document}
```

:::{tip}
Pour obtenir un filet horizontal double, par exemple en dessous de la première ligne, on
pourra utiliser les deux lignes ci-dessous dans le desrciptif du tableau :

```{noedit}
hline{2}={1}{-}{solid},
hline{2}={2}{-}{solid}
```
:::

## Création de ses propres environnements de tableaux

<ctanpkg:tabularray> fournit une commande permettant de créer des tableaux types.

Dans l’exemple ci-dessous, on prépare une grille d’évaluation.

:::{tip}
On ne connaît pas *a priori* le nombre de lignes et de colonnes à l’avance. On utilise donc
une possibilité fort pratique de <ctanpkg:tabularray> : pour la sélection des cellules avec `cell`,
les valeurs `U`, `V`, `W`, `X`, `Y` et `Z` désignent respectivement les six dernières colonnes (ou lignes). 

**On peut donc décider des caractéristiques des six dernières lignes sans connaître leur position.**
:::

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{xcolor}
\usepackage{tabularray}
\usepackage{babel}

\begin{document}


% Création du tableau « grille »
\NewTblrEnviron{grille}
\SetTblrInner[grille]{
	width=.9\linewidth,
	colspec = {|X[4]|X[4]|X|},
	hlines,
	hline{2,Y} ={1}{-}{solid},
	hline{2,Y} = {2}{-}{solid},
	columns = {valign=m},
	column{Z} = {halign=r, font=\large},
	rows = {.8cm},
	row{1} = {font=\bfseries,halign=c, bg=azure9},
	row{Z} = {font=\bfseries\large, bg=azure9},
	cell{Z}{1} = {c=2}{c},
}
% -------------------------------------------------------------------------------
% Appel et utilisation du tableau
\begin{grille}{} % penser à la paire d’accolades vide ici 
	Compétences
		& Observable
		& Points  \\
		APP - rechercher l'information utile
		& identifier le solvant extracteur dans le protocole
		& /2 \\
	%
	REA - réaliser des calculs
		& {applications numériques correctes; \\ conversions}
		& /2 \\
	%
	VAL - comparer un résultats à une valeur de référence
		& comparer la valeur obtenue avec celle donnée dans le doc 2
		& /1.5  \\
	%	
	COM - présenter une démarche
		& {rédaction; \\ utilisation du vocabulaire scientifique}
		& /3 \\
	%
    COM - utiliser le langage mathématique
		& rédaction du développement littéral
		& 1.5 \\
    TOTAL 
		& 
		& /10 \\
\end{grille}

\end{document}
```


:::{warning}
Attention à ne pas oublier la paire d’accolades vide lors de l’appel du tableau !
:::

## Tableau sur plusieurs pages

<ctanpkg:tabularray> fournit l’environnement `longtblr` qui permet au tableau de se
poursuivre sur plusieurs pages. L’en-tête et le pied du tableau seront alors répétés sur
chaque page.

:::{note}
Pour en savoir plus sur les tableaux sur plusieurs pages : [](/3_composition/tableaux/tableau_sur_plusieurs_pages.md)
:::
