/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : score.h
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/
#ifndef __SCORE_H
#define __SCORE_H

#ifndef __STRiNG_H
#include "string.h"
#endif

class ifstream;
class ofstream;
class istream;
class ostream;

#ifndef __STAFFLIST_H
#include "staflist.h"
#endif

/****************************************************************************
  class Score
--*/

class Score : public StaffList 
{
    void checkBarDuration();
			  /* begin/end of file */
    void doFooter();
    void doHeader();
    int getShortest();
    int getSpacing( int lastSpacing ); /* shortest note (vertically) in staff. This is "bottleneck" for
						   spacing. */
    /*virtual*/ void printBarOn( ostream& os );

public:
    String outName;
    ostream* codeFile; 

    void process(); /* big work done here */

    Score( const char* name );
    virtual ~Score();
};

#define ScoreIterator StaffListIterator
//-- class Score //

#endif // __SCORE_H //
