// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
static const char rcsid[] = "$Header: stack.C,v 1.7 91/02/22 15:57:07 hmgr Exp $";

// manipulate a DVI stack
//
// by Parag Patel

#include "defs.h"


// a stack representation
struct stkrep
{
    double h, v, w, x, y, z;
};

declare_array(Stack, stkrep);
implement_array(Stack, stkrep);

static int top = 0;			// top of the stack;
static Stack sp(50);			// the DVI stack itself


// save current DVI/TeX variable values
// 
void pushdvi()
{
    sp[top].h = H;
    sp[top].v = V;
    sp[top].w = W;
    sp[top].x = X;
    sp[top].y = Y;
    sp[top].z = Z;
    top++;
}


// restore current DVI/TeX variable values
// 
void popdvi()
{
    if (top <= 0)
	quit("Stack underflow");
    top--;
    H = sp[top].h;
    V = sp[top].v;
    W = sp[top].w;
    X = sp[top].x;
    Y = sp[top].y;
    Z = sp[top].z;
}


// clear the stack and dvi vars
// 
void cleardvi()
{
    H = V = W = X = Y = Z = 0.0;
    top = 0;
}
